	% Problem 12.6 LP-> BP Cauer
	clear all, clc
	
	% Requirements for the digital bandpass filter
	wc1T = 0.2*pi;		wc2T = 0.3*pi;
	ws1T = 0.15*pi;		ws2T = 0.4*pi;
	Amax = -10*log10(1-0.15^2);		Amin = 60; T = 1;	
	% Requirements for the analog prototype lowpass filter
	Wac1 = (2/T)*tan(wc1T/2);	Wac2 = (2/T)*tan(wc2T/2);
	Was1 = (2/T)*tan(ws1T/2);	Was2 = (2/T)*tan(ws2T/2)		
	Was2 = Wac1*Wac2/Was1, T = 1;
	% Band edges for the  analog filter
	Omegac = Wac2 - Wac1;	Omegas = Was2 - Was1;	
	% Design of the analog prototype lowpass filter (Cauer)
	N = CA_ORDER_S(Omegac, Omegas, Amax, Amin)
	N = 5;	% We must select an integer order
	% Design of the analog prototype lowpass filter (Cauer)
	[Ga, Za, R_ZEROS, Pa, Wsnew] = CA_POLES_S(Omegac, Omegas, Amax, Amin, N);	
	
	% Transformation the analog filter into a lowpass digital filter
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, T);
	% Transformation the lowpass filter into a digital bandpass filter
	[Gbp, Zbp, Pbp] = PZ_2_BP_Z(G, Z, P, wc1T, wc2T, Omegac*T);
	figure(1)
	PLOT_PZ_Z(Zbp, Pbp)			
	[Zodd, Podd, Xeven, Peven] = SORT_LATTICE_POLES_BP_Z(Pbp);
	figure(2), 	wT = linspace(0, pi, 1000);
	[alfa_odd, alfa_even] = CASCADE_RICHARDS_SECTIONS(Podd, Peven)
	[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wT);
	subplot(2,1,1); Att = MAG_2_ATT(0.5*(S2-S1));
	PLOT_ATT_Z(wT, Att, pi, 70)						
	
	for n = 1:2*N
		Pbp(n)
		F = abs(atan(imag(Pbp(n))/real(Pbp(n))))	
	end
	
